-- *******************************************************************************************************
-- Beginn der Bibliotheksfunktionen
-- *******************************************************************************************************

-- ======================================================================================================
-- Pfad-Objekt
-- ======================================================================================================

CPathObject = {};

function CPathObject:new()

    local tblInstance   =   
            { 
                m_nCurrentLevel = 0, 
                m_nLevels = 0, 
                m_aVarLevel={} 
            };
    
    setmetatable( tblInstance, self );
    self.__index    =   self;
    return tblInstance;
end

function CPathObject:_setPath( strPath )
    local i = 0
    local w
    local wNumber
    
    self.m_aVarLevel[0] = E.PVTable
    for w in string.gmatch( strPath, "[%w_%s]+") do
        -- E:trace("w: " .. w )
        i=i+1
        wNumber = tonumber(w,10)
        if (nil == wNumber) then
            self.m_aVarLevel[i] = self.m_aVarLevel[i-1][w]
        else
            self.m_aVarLevel[i] = self.m_aVarLevel[i-1][wNumber]
        end
    end
    self.m_nLevels = i
    self.m_nCurrentLevel = i
end

function CPathObject:_getLevels()
    return self.m_nLevels
end

function CPathObject:_getNode( nNodeLevel )
    -- E:trace( "_getNodeVar(" ..nNodeLevel.. ")")
    return self.m_aVarLevel[nNodeLevel]
end

function CPathObject:_getNode()
    -- E:trace( "_getNodeVar(" ..self.m_nCurrentLevel.. ")")
    return self.m_aVarLevel[self.m_nCurrentLevel]
end

function CPathObject:_levelUp()
    if (self.m_nCurrentLevel > 0) then
        self.m_nCurrentLevel = self.m_nCurrentLevel-1
        return self.m_aVarLevel[self.m_nCurrentLevel]
    end
    return nil
end

function CPathObject:_levelDown()
    if (self.m_nCurrentLevel < self.m_nLevels) then
        self.m_nCurrentLevel = self.m_nCurrentLevel+1
        return self.m_aVarLevel[self.m_nCurrentLevel]
    end
    return nil
end

function CPathObject:_toLeaf()
    self.m_nCurrentLevel = self.m_nLevels;
    return self.m_aVarLevel[self.m_nCurrentLevel]
end

function CPathObject:_getLeaf()
    -- E:trace( "_getLeafVar()")
    return self.m_aVarLevel[self.m_nLevels]
end

function CPathObject:_findParentFromUserType( usertype )

    local oDevice = self:_toLeaf()
    if (nil == oDevice) then
        return nil
    end
    
    repeat
        if (type(oDevice) == "table") and (oDevice.E_Type == "e_pvFolder") and (usertype == oDevice.E_UserType) then
            return oDevice
        end
        oDevice = self:_levelUp()
    until (nil == oDevice)

    return nil
end


function GetPathObject( strVarPath )

    local oVarPath = CPathObject:new()
    
    oVarPath:_setPath( strVarPath )
    return oVarPath
end


-- ======================================================================================================
-- Globale Konstanten
-- ======================================================================================================

-- Grnde, die eine Wertmeldung an das Prozessmodell haben knnen:

constValueChange         = 1        -- Meldung einer Wertnderung
constResponse            = 2        -- Antwort auf Abfrage
constResponseFromCache   = 3        -- Antwort auf Abfrage, Wert wurde aus Cache ermittelt
constWriteAck            = 4        -- Acknowledge fr Write Befehl, der besttigte Wert wird als Wert des Datenpunktes bernommen

-- Grnde, die eine Wertanforderung vom Prozessmodell haben knnen:

constValueRead           = 1        -- Generelle Wertabfrage
constWriteReadCmd        = 2        -- Expliziten Lesebefehl an Prozess senden
constGetUpdate           = 3        -- Initialisierung der Variablen, wird angefordert nach Start des Prozessmodells

-- Zugriffsrechte, die im Gerteeditor vom Benutzer eingestellt werden knnen

constAccessNone          = 0        -- keine
constAccessRead          = 1        -- Nur Lesen erlaubt
constAccessWrite         = 2        -- Nur Schreiben erlaubt
constAccessReadWrite     = 3        -- Lesen und Schreiben erlaubt

-- *******************************************************************************************************
-- Ende der Bibliotheksfunktionen
-- *******************************************************************************************************

